<?php

/**
 * Class TimekeeperModel. Cronometradores
 */
class TimekeeperModel extends CI_Model


{
    const TABLE_NAME = 'Cronometrador';

    /**
     * TimekeeperModel constructor.
     */
    public function __construct()
    {
        parent::__construct();
        $this->load->database();
    }

    /**
     * Funcion para crear un nuevo cronometrador
     * @param $email Identificador del cronometrador
     * @param $dni Dni
     * @param $name Nombre del cronometrador
     * @param $surname Primer apellido del cronometrador
     * @param $surname2 Segundo apellido del cronometrador
     * @param $password Contraseña
     * @return true en caso de que se cree correctamente, false en caso contrario
     */
    public function createTimekeeper($email,
                                     $dni,
                                     $name,
                                     $surname,
                                     $surname2,
                                     $password)
    {
        $timekeeper = array(
            'email' => $email,
            'dni' => $dni,
            'nombre' => $name,
            'apellido1' => $surname,
            'apellido2' => $surname2,
            'password' => $password

        );

        return $this->db->insert(self::TABLE_NAME, $timekeeper);
    }

    /**
     * Funcion que retorna todos los cronometradores
     * @return Cronometrador[] con todos sus datos
     */
    public function getTimekeepers() {
        $sql = 'SELECT E.* FROM Cronometrador E ORDER BY E.nombre ASC';
        $query =  $this -> db -> query($sql);
        return $query -> result();
    }


    /**
     * Funcion que retorna si existe o no un cronometrador en funcion de los parametros dados
     * @param $dni Identificador del cronometrador
     * @param $email Email del cronometrador
     * @return bool true en caso de que exista, false en caso contrario
     */
    public function existsTimekeeper($dni, $email) {
        $sql = 'SELECT T.* FROM Cronometrador T WHERE T.email= ?';
        $query = $this -> db -> query($sql,array($email));

        $sql2 = 'SELECT T.* FROM Cronometrador T WHERE T.dni= ?';
        $query2 = $this -> db -> query($sql2,array($dni));
        return $query->num_rows() != 0 || $query2 -> num_rows() != 0;
    }

    /**
     * Funcion para cambiar la contraseña del cronometrador
     * @param $email Identificador del cronometrador
     * @param $password Nueva contraseña a setear
     * @return bool true en caso de que se haya cambiado correctamente, false en caso contrario
     */
    public function changePassword($email,$password) {
        $data = array(
            'password' => $password
        );
        $this -> db -> where('email',$email);
       return $this -> db -> update(self::TABLE_NAME,$data);
    }

    /**
     * Verificar si la contraseña pasada por parametro es la misma que la que esta
     * almacenada en base de datos en formato BYCRYPT
     * @param $email Identificador del cronometrador
     * @param $password Contraseña a verificar
     * @return true en caso de que coincidan, false en caso contrario
     */
    public function validatePassword($email,$password) {

        $this -> db -> select ('password');
        $this -> db -> where ('email',$email);
        $query = $this -> db -> get(self::TABLE_NAME);
        $password_hash = $query -> result()[0] -> password;
        return password_verify($password,$password_hash);
    }

    /**
     * Funcion que retorna si existe un cronometrador con el email pasado por parametro
     * @param $email Identificador del cronometrador que se quiere verificar
     * @return true en caso de que exista el email false en caso contrario
     */
    public function existsEmail($email) {
        $sql = 'SELECT * FROM Cronometrador D WHERE D.email = ?';
        $query =  $this -> db -> query($sql,array($email));

        return $query->num_rows() != 0;
    }

    /**
     * Devuelve un array con los cronometradores disponibles de ese campeonato, es
     * decir, los que no estan asociados a ningun tatami de la competición
     * @param $idCompetition
     * @return mixed
     */
    public function getTimekeepersByIDCompetition($idCompetition) {
        $sql = 'SELECT * FROM Cronometrador C  WHERE  C.email NOT IN (SELECT T.emailCronometrador 
                                                                    FROM Tatami T, Competicion CO 
                                                                    WHERE T.emailCronometrador = C.email and T.idCompeticion = CO.idCompeticion and CO.idCompeticion = ?)';
        $query = $this -> db -> query ($sql,array($idCompetition));
        return $query -> result();
    }

    /**
     * Funcion para añadir un cronometrador a un tatami de una competicion
     * @param $idMat Identificador del tatami
     * @param $email Email del cronometrador que se va a asignar al tatmai
     * @throws Exception si no se añade a la base de datos
     */
    public function addTimekeeperToMat($idMat,$email) {
        $inscription = array(
            'emailCronometrador' => $email

        );

        $this->db->trans_start();
        $this -> db -> where('idTatami',$idMat);
        $this->db->update('Tatami', $inscription);
        $this->db->trans_complete();
        if (!$this->db->trans_status()) throw new Exception('Error, no se pudo crear la inscripcion');
    }

    /**
     * Funcion que devuelve los tatamis que tiene un determinado cronometrador con la informacion
     * de la competicion al que corresponda(n) ese/os tatami(s).
     * @param $emailCronometrador
     */
    public function getMats($emailCronometrador) {
        $sql = 'SELECT T.*, C.*
                FROM Tatami T, Competicion C  
                WHERE T.emailCronometrador = ? AND T.idCompeticion = C.idCompeticion
                ORDER BY C.fecha';
        $query = $this -> db -> query($sql,array($emailCronometrador));

        return $query -> result();

    }

}